<?php

namespace Cms\Client\Campsite;

use Cms\Client\AbstractClient;
use Cms\Client\Campsite\Model\FeatureRestfulModel;
use Cms\Client\ClientFetchStrategy;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\Campsite\Feature\FeatureFieldFlagSet;
use Cms\Model\Campsite\Feature\FeatureI18nCollection;
use Move\Http\Client\HttpClientInterface;
use Move\ObjectMapper\ObjectTransformer;

/**
 * Class FeatureClient
 * @package Cms\Client\Campsite
 */
class FeatureClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'campsite/feature';

    /** @var string */
    protected $fetchStrategy = ClientFetchStrategy::FETCH_ASYNC;

    /**
     * FeatureClient constructor.
     * @param HttpClientInterface $client
     * @throws \UnexpectedValueException
     */
    public function __construct(HttpClientInterface $client)
    {
        $transformer = new ObjectTransformer();
        $transformer->modify('field_flag', function ($fieldFlag) {
            if ($fieldFlag instanceof FeatureFieldFlagSet) {
                return $fieldFlag->getArrayCopy();
            }
            return $fieldFlag;
        });
        $transformer->modify('i18n', function ($i18n, ObjectTransformer $transformer) {
            if ($i18n instanceof FeatureI18nCollection) {
                return array_map($transformer, $i18n->getModels());
            }
            return $i18n;
        }, [$transformer]);
        parent::__construct($client, $transformer);
    }

    /**
     * @param array $dataset
     * @return FeatureRestfulModel
     */
    public function handleData($dataset = []) : FeatureRestfulModel
    {
        return (new FeatureRestfulModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|FeatureRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpServerException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param string $valueType
     * @return \Cms\Client\CmsApiIndexIterator|FeatureRestfulModel[]
     */
    public function getFeatureByValueType(string $valueType) : CmsApiIndexIterator
    {
        return $this->getBuilder()
            ->setFilter('value_type', $valueType)
            ->getIndex(-1);
    }
}
