<?php


namespace Cms\Client\Command\Article\Command;

use Cms\Client\Command\ScopeFilterAwareInterface;
use Cms\Client\Command\ScopeFilterAwareTrait;

/**
 * Class AbstractFetchLinkedTypeCommand
 * @package Cms\Client\Command\Article\Command
 */
abstract class AbstractFetchLinkedTypeCommand implements ScopeFilterAwareInterface
{

    use ScopeFilterAwareTrait;

    /** @var bool */
    protected $most_used = false;

    /** @var  string */
    protected $article_profil;

    /** @var  int */
    protected $article_category_id;

    /** @var \Cms\LinkResource\LinkResourceType|string */
    protected $linkType;

    /**
     * @return boolean
     */
    public function hasMostUsed()
    {
        return $this->most_used;
    }

    /**
     * @param boolean $most_used
     * @return $this
     */
    public function setMostUsed($most_used)
    {
        $this->most_used = $most_used;
        return $this;
    }

    /**
     * @return string
     */
    public function getArticleProfil()
    {
        return $this->article_profil;
    }

    /**
     * @param string $article_profil
     * @return $this
     */
    public function setArticleProfil($article_profil)
    {
        $this->article_profil = $article_profil;
        return $this;
    }

    /**
     * @return int|array
     */
    public function getArticleCategoryId()
    {
        return $this->article_category_id;
    }

    /**
     * @param int|array $article_category_id
     * @return $this
     */
    public function setArticleCategoryId($article_category_id)
    {
        $this->article_category_id = $article_category_id;
        return $this;
    }

    /**
     * @return \Cms\LinkResource\LinkResourceType|string
     */
    public function getLinkType()
    {
        return $this->linkType;
    }

    /**
     * @param \Cms\LinkResource\LinkResourceType|string $linkType
     * @return $this
     */
    public function setLinkType($linkType)
    {
        $this->linkType = $linkType;
        return $this;
    }
}
