<?php

namespace Cms\Client\Geodata;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Client\Geodata\Model\AdminRestfulModel;

/**
 * Class AdminClient
 * @package Cms\Client\Geodata
 */
class AdminClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'geodata/admin';

    /**
     * @param array $dataset
     * @return AdminRestfulModel
     */
    public function handleData($dataset = []) : Model\AdminRestfulModel
    {
        return (new AdminRestfulModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|AdminRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param string $search
     * @param string|null $countryCode
     * @param int|null $level
     * @param int $pageNum
     * @return \Cms\Client\CmsApiIndexIterator|\Cms\Client\Geodata\Model\AdminRestfulModel[]|null
     */
    public function getIndexBySearch(string $search, string $countryCode = null, int $level = null, int $pageNum = 0)
    {
        return $this->getBuilder()
            ->setFilter('search', $search)
            ->setFilter('level', $level)
            ->setFilter('country_code', $countryCode)
            ->getIndex($pageNum);
    }

    /**
     * @param string $countryCode
     * @param string $code
     * @param int $level
     * @param int $page
     * @return CmsApiIndexIterator|AdminRestfulModel[]|null
     */
    public function fetchAllByCountry($countryCode, $code = null, $level = 1, $page = 0)
    {
        return $this->getBuilder()
            ->setFilter('country_code', $countryCode)
            ->setFilter('code', $code)
            ->setFilter('level', $level)
            ->getIndex($page);
    }
}
