<?php

namespace Cms\Client\Service;

use Cms\Client\CmsHttpClientInterface;
use Cms\Client\Command\Member\Command\FetchMemberCommand;
use Cms\Client\Command\Member\Command\SetNewsletterCommand;
use Cms\Client\Command\Member\MemberCommandHandler;
use Cms\Client\Member\MemberClient;
use Cms\Client\Member\MemberRewardClient;
use Cms\Client\Member\Transformer\MemberTransformer;
use League\Container\Argument\RawArgument;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;
use Move\Command\TacticianBusFactory;

/**
 * Class MemberProvider
 * @package Cms\Client\Service
 */
class MemberProvider extends AbstractServiceProvider implements BootableServiceProviderInterface
{

    /** @var array */
    protected $provides = [
        MemberCommandHandler::class,
        MemberService::class,
        MemberClient::class,
        MemberTransformer::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        // add clients
        $this->container->add(MemberClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add container
        $this->container->add(MemberCommandHandler::class)
            ->withArgument(MemberClient::class)
            ->withArgument(MemberRewardClient::class);

        // add transformer
        $this->container->add(MemberTransformer::class);

        // add command bus
        $bus = TacticianBusFactory::mapToClassHandler($this->container, [
            FetchMemberCommand::class,
            SetNewsletterCommand::class,
        ], MemberCommandHandler::class);

        // add services
        $this->container->add(MemberService::class)
            ->withArguments([
                MemberClient::class,
                new RawArgument($bus),
                MemberTransformer::class,
            ]);
    }

    /**
     * Method will be invoked on registration of a service provider implementing
     * this interface. Provides ability for eager loading of Service Providers.
     * @return void
     */
    public function boot()
    {
        $this->container->addServiceProvider(new MemberRewardProvider());
    }
}
