<?php


namespace Cms\Engine\Decorator;

use Cms\Model\Article\Category\CategoryPluginModel;
use Cms\Model\Article\Category\CategoryPluginType;
use Move\Command\Chain\AbstractHandler;
use Move\Template\AssetEngineTrait;
use Move\Template\EngineAwareTrait;
use Move\Template\Extensions\SmartAd;
use Move\Template\Html\Asset\Xiti;

/**
 * Class DecoratorPluginHandler
 * @package Cms\Engine\Decorator
 */
class DecoratorPluginHandler extends AbstractHandler implements EngineDecoratorInterface
{

    use EngineAwareTrait;
    use AssetEngineTrait;

    /**
     * Processes the request.
     * This is the only method a child can implements,
     * with the constraint to return null to dispatch the request to next successor.
     * @param $request
     * @return null|mixed
     */
    protected function process($request)
    {
        // on ne traite que les plugins
        if (!$request instanceof CategoryPluginModel) {
            return null;
        }
        switch ((string)$request->type) {
            case CategoryPluginType::SMART_AD:
                // assign de la page ID
                if (!empty($request->config['pageId'])) {
                    SmartAd::setPageId($request->config['pageId']);
                } elseif (!empty($request->config['homePageId'])) {
                    SmartAd::setPageId($request->config['homePageId']);
                }
                // applique les targets
                if (!empty($request->config['keywords'])) {
                    foreach (explode(';', $request->config['keywords']) as $keywordsPart) {
                        list($name, $value) = explode('=', $keywordsPart);
                        if (!empty($name) && !empty($value)) {
                            SmartAd::addInTarget($name, array_map('trim', explode(',', $value)));
                        }
                    }
                }
                break;
        }
        return $this;
    }
}
