<?php

namespace Cms\Model\Article\CoverList;

use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\ScopeAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class CoverListModel
 * @package Cms\Model\Article\CoverList
 * @property int $id
 * @property int $category_id
 * @property CoverListState $state
 */
class CoverListModel extends DomainObjectAbstract
{

    use StampAwareModelTrait;
    use ScopeAwareModelTrait;
    use CmsUserIdAwareTrait;

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $category_id;

    /** @var  CoverListState */
    protected $state;
}
