<?php

namespace Cms\Model\Asset;

use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\ScopeAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class AssetModel
 * @package Cms\Model\Asset
 * @property int $id
 * @property string $credit
 * @property string $filename
 * @property string $content
 * @property string $mime
 * @property AssetProfil $profil
 */
class AssetModel extends DomainObjectAbstract
{

    use StampAwareModelTrait;
    use ScopeAwareModelTrait;
    use CmsUserIdAwareTrait;

    /** @var  int */
    protected $id;

    /** @var  string */
    protected $credit;

    /** @var  string */
    protected $filename;

    /** @var  string */
    protected $content;

    /** @var  string */
    protected $mime;

    /** @var  AssetProfil */
    protected $profil;
}
