<?php

namespace Cms\Model\Campsite\Product;

use Cms\Model\I18nModelInterface;
use Cms\Model\I18nModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class ProductI18nModel
 * @package Cms\Model\Campsite\Product
 * @property int $product_id
 * @property string $name
 * @property string $name_dyn
 * @property string $short_description
 * @property string $description
 */
class ProductI18nModel extends DomainObjectAbstract implements I18nModelInterface
{

    use I18nModelTrait;

    /**
     * @relation
     * @var int
     */
    protected $product_id;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $help_desc;

    /** @var  string */
    protected $description;
}
