<?php


namespace Cms\Search\Article;

use Cms\Search\AbstractSearchClient;

/**
 * Class ArticleSearchClient
 * @package Cms\Search\Article
 */
class ArticleSearchClient extends AbstractSearchClient
{

    /**
     * @var array
     */
    protected $sortCols = [
        'id',
        'category_id',
        'modified_at',
        'created_at',
        'last_published_at',
    ];

    /**
     * @return array
     */
    protected function getDefaultMatchFields() : array
    {
        return ['title^5', 'abstract', 'content'];
    }

    /**
     * @return string
     */
    protected function getMappingType() : string
    {
        return ArticleIndexFactory::MAPPING_NAME;
    }
}
