<?php

namespace Move\Advertiser\Google\DfpSmallBusiness;

/**
 * Class Size
 * @package Move\Advertiser\Google\DfpSmallBusiness
 */
class Size implements \JsonSerializable
{
    /** @var int */
    public $width;

    /** @var int */
    public $height;

    /**
     * Size constructor.
     * @param int $width
     * @param int $height
     */
    public function __construct(int $width = 0, int $height = 0)
    {
        $this->width = $width;
        $this->height = $height;
    }

    /**
     * Specify data which should be serialized to JSON
     * @link http://php.net/manual/en/jsonserializable.jsonserialize.php
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource.
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        return [$this->width, $this->height];
    }
}
