<?php


namespace Move\Command\Command;

/**
 * Class FetchBulkCommand
 * @package Move\Command\Command
 */
class FetchBulkCommand implements \IteratorAggregate, \Countable
{

    /** @var array */
    private $ids;

    /**
     * FetchBulkEditionCommand constructor.
     * @param array $ids
     */
    public function __construct(array $ids)
    {
        $this->ids = $ids;
    }

    /**
     * @return array
     */
    public function getIds() : array
    {
        return $this->ids;
    }

    /**
     * @param array $ids
     * @return $this
     */
    public function setIds(array $ids)
    {
        $this->ids = $ids;
        return $this;
    }

    /**
     * @param string|int $id
     * @return $this
     */
    public function appendId($id)
    {
        if (is_scalar($id) && !\in_array($id, $this->ids)) {
            $this->ids[] = $id;
        }
        return $this;
    }

    /**
     * Retrieve an external iterator
     * @link http://php.net/manual/en/iteratoraggregate.getiterator.php
     * @return \Traversable An instance of an object implementing <b>Iterator</b> or
     * <b>Traversable</b>
     * @since 5.0.0
     */
    public function getIterator() : \Traversable
    {
        return new \ArrayIterator($this->ids);
    }

    /**
     * Count elements of an object
     * @link http://php.net/manual/en/countable.count.php
     * @return int The custom count as an integer.
     * </p>
     * <p>
     * The return value is cast to an integer.
     * @since 5.1.0
     */
    public function count()
    {
        return count($this->ids);
    }
}
