<?php

namespace Move\Command\Command;

/**
 * Class UpdateCommand
 * @package Move\Command\Command
 */
class UpdateCommand implements DryRunCommandInterface
{

    use DryRunCommandTrait;

    /** @var  int */
    protected $id;

    /** @var  array */
    protected $dataset;

    /**
     * UpdateCommand constructor.
     * @param int $id
     * @param array $dataset
     */
    public function __construct($id, array $dataset)
    {
        $this->id = $id;
        $this->dataset = $dataset;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return UpdateCommand
     */
    public function withId($id) : UpdateCommand
    {
        $clone = clone $this;
        $clone->id = $id;
        return $clone;
    }

    /**
     * @return array
     */
    public function getDataset() : array
    {
        return $this->dataset;
    }

    /**
     * @param array $dataset
     * @return UpdateCommand
     */
    public function withDataset(array $dataset) : UpdateCommand
    {
        $clone = clone $this;
        $clone->dataset = $dataset;
        return $clone;
    }
}
