<?php

namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\Oembed;
use Move\Embed\Parser\MultiRegexParser;

/**
 * Class Instagram
 * @package Embed\AdapterProvider
 */
class Instagram extends AbstractAdapterProvider
{

    /**
     * @return Oembed
     */
    public function getAdapter()
    {
        $oembed = new Oembed('https://api.instagram.com/oembed', [
            'omitscript' => true
        ]);
        return $oembed;
    }

    /**
     * @inheritdoc
     */
    public function getParser()
    {
        $regexParser = new MultiRegexParser([
            '@^(https?:)?//(?:www.)?instagr(am\.com|\.am)/p/([a-zA-Z0-9]+)@i',
        ]);
        return $regexParser;
    }
}
