<?php

namespace Move\Search\Analyzer;

/**
 * Class WordAnalyzer
 * @package Move\Search\Analyzer
 */
class WordAnalyzer extends ElasticAnalyzer
{
    /**
     * WordAnalyzer constructor.
     * @param string|null $name
     */
    public function __construct(string $name = null)
    {
        parent::__construct($name ?: 'word_analyzer', 'whitespace');
        $this
            ->setFilter('standard')
            ->setFilter('lowercase')
            ->setFilter('asciifolding')
            ->setFilter('multi_words', PredefinedFilterAnalyzer::FILTER_MULTI_WORDS)
            ->setFilter('autocomplete', PredefinedFilterAnalyzer::FILTER_AUTOCOMPLETE);
    }
}
