<?php

namespace Move\Search;

use Elastica\Index;
use Elastica\Type\Mapping;
use Move\Search\Mapping\ElasticMappingProperty;

/**
 * Class ElasticMappingBuilder
 * @package Move\Search
 */
class ElasticMappingBuilder implements ElasticMappingBuilderInterface
{

    /** @var string */
    private $typeName;

    /** @var ElasticMappingProperty[] */
    private $properties;

    /**
     * ElasticMappingBuilder constructor.
     * @param string $typeName
     * @param ElasticMappingProperty[]|null $properties
     */
    public function __construct(
        string $typeName,
        array $properties = null
    ) {
        $this->typeName = $typeName;
        if ($properties !== null) {
            foreach ($properties as $property) {
                $this->setProperty($property);
            }
        }
    }

    /**
     * @param \Elastica\Index $index
     * @param string $typeName
     * @param bool $recreate
     * @return \Elastica\Type\Mapping
     */
    public function createMapping(
        Index $index,
        string $typeName = null,
        bool $recreate = false
    ) : Mapping {
        // check des properties
        $props = $this->properties;
        // récuperation du type
        $type = $index->getType($typeName ?: $this->typeName);
        // creation du mapping
        $elasticMapping = new Mapping($type, $props);
        $elasticMapping->send();
        return $elasticMapping;
    }

    /**
     * @param string $typeName
     * @return $this
     */
    public function setTypeName(string $typeName)
    {
        $this->typeName = $typeName;
        return $this;
    }

    /**
     * @param \Move\Search\Mapping\ElasticMappingProperty $property
     * @return $this
     */
    public function setProperty(ElasticMappingProperty $property)
    {
        $this->properties[$property->getPropName()] = $property->toArray();
        return $this;
    }

    /**
     * @return array
     */
    public function getPropertyNames() : array
    {
        return array_keys($this->properties);
    }
}
