<?php

namespace Move\Http\Route;

use League\Route\RouteCollection;
use League\Route\RouteGroup;
use League\Route\Strategy\StrategyInterface;
use PHPUnit\Framework\TestCase;

class LeagueRouteGroupRegistrerTest extends TestCase
{

    /**
     * @covers LeagueRouteGroupRegistrer::__construct
     * @return LeagueRouteGroupRegistrer
     */
    public function testConstruct()
    {
        $group = new LeagueRouteGroupRegistrer([
            ['GET', '/dummy/prefix', 'DummyController::handleRequest1'],
            ['GET', '/dummy/prefix2', 'DummyController::handleRequest2']
        ]);
        return $group;
    }

    /**
     * @covers LeagueRouteGroupRegistrer::__construct
     * @return LeagueRouteGroupRegistrer
     */
    public function testConstructWithStrategy()
    {
        $strategy = $this->getMockBuilder(StrategyInterface::class)
            ->getMock();
        $group = new LeagueRouteGroupRegistrer([], $strategy);
        return $group;
    }

    /**
     * @depends testConstruct
     * @covers LeagueRouteGroupRegistrer::map
     * @param LeagueRouteGroupRegistrer $instance
     */
    public function testMap(LeagueRouteGroupRegistrer $instance)
    {
        $routeCollection = new RouteCollection();
        $group = new RouteGroup('/suffix1', function() {}, $routeCollection);
        $instance->map($group);
    }

    /**
     * @expectedException \InvalidArgumentException
     */
    public function testMapThrowsInvalidArgumentException()
    {
        $instance = new LeagueRouteGroupRegistrer([
            ['GET', '/dummy/suffix']
        ]);

        /** @var RouteCollection $routeCollection */
        $routeCollection = $this->getMockBuilder(RouteCollection::class)
            ->getMock();

        $group = new RouteGroup('/suffix1', function() {}, $routeCollection);

        $instance->map($group);
    }
}
