<?php


namespace Cms\Client\AddressBook;

use Cms\Client\AbstractClient;
use Cms\Client\AddressBook\Model\AddressBookRestfulModel;
use Cms\Client\CmsApiIndexIterator;

/**
 * Class AddressBookClient
 * @package Cms\Client\AddressBook
 */
class AddressBookClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'addressbook';

    /**
     * @param array $dataset
     * @return AddressBookRestfulModel
     */
    public function handleData($dataset = [])
    {
        return (new AddressBookRestfulModel())->populate($dataset ?: [], true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|AddressBookRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpServerException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param int $scopeId
     * @param string $search
     * @param int $pageNum
     * @return Model\AddressBookRestfulModel[]|CmsApiIndexIterator
     */
    public function fetchAllBySearch($scopeId, $search, $pageNum = 0)
    {
        return $this->getBuilder()
            ->setFilter('scope', $scopeId)
            ->setFilter('search', $search)
            ->getIndex($pageNum);
    }

    /**
     * @param string $scope
     * @param string $slug
     * @return null|AddressBookRestfulModel
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function fetchItemBySlug($scope, $slug)
    {
        $object = $this->fetchItem($slug, [
            'scope' => $scope,
        ]);
        return $object;
    }
}
