<?php


namespace Cms\Client\Command\Article;

use Cms\Client\Article\Model\CategoryRestfulModel;
use Cms\Decorator\DomainObjectDecoratorInterface;
use POM\DomainObjectInterface;

/**
 * Class CategoryFilterDecorator
 * @package Cms\Client\Command\Article
 */
class CategoryFilterDecorator implements DomainObjectDecoratorInterface
{

    /**
     * @param DomainObjectInterface $object
     * @param CategoryFilterAwareInterface $filter
     * @return CategoryFilterAwareInterface
     */
    public function setFilterFromModel(
        DomainObjectInterface $object,
        CategoryFilterAwareInterface $filter
    ) {
        // ajout du filtre par edition
        if (!empty($object) && $object instanceof CategoryRestfulModel) {
            $categoryIds = [$object->id];
            $filter->setCategoryIds($categoryIds);
            if (!$object->parent_id) {
                $filter->setParentCategoryId($object->id);
            }
        }
        return $filter;
    }

    /**
     * @param DomainObjectInterface $object
     * @param mixed $command
     * @return mixed
     */
    public function decorate(DomainObjectInterface $object, $command)
    {
        if ($command instanceof CategoryFilterAwareInterface) {
            return $this->setFilterFromModel($object, $command);
        }
        return $command;
    }
}
