<?php


namespace Cms\Client\Command\Article\Command;

use Cms\Client\Command\ScopeFilterAwareInterface;
use Cms\Client\Command\ScopeFilterAwareTrait;
use Move\Command\Command\FetchCommand;

/**
 * Class FetchRubriqueCommand
 * @package AutoMag\Command\Rubrique\Command
 */
class FetchArticleCategoryCommand extends FetchCommand implements ScopeFilterAwareInterface
{

    use ScopeFilterAwareTrait;

    /**
     * @var string|null
     */
    private $slug;

    /** @var int */
    private $slugLevel;

    /**
     * @var string|null
     */
    private $language;

    /**
     * FetchRubriqueCommand constructor.
     * @param null|string $rubriqueSlug
     * @param null|int $rubriqueId
     */
    public function __construct($rubriqueSlug = null, $rubriqueId = null)
    {
        $this->slug = $rubriqueSlug;
        $this->slugLevel = -1;
        parent::__construct($rubriqueId);
    }

    /**
     * @deprecated
     * @return string|null
     */
    public function getRubriqueSlug()
    {
        return $this->getSlug();
    }

    /**
     * @return null|string
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * @param string $slug
     * @return $this
     */
    public function setSlug(string $slug)
    {
        $this->slug = $slug;
        return $this;
    }

    /**
     * @param null|string $language
     * @return $this
     */
    public function setLanguage($language)
    {
        $this->language = $language;
        return $this;
    }

    /**
     * @return null|string
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @return int|null
     */
    public function getSlugLevel()
    {
        return $this->slugLevel;
    }

    /**
     * @param int|null $slugLevel
     * @return $this
     */
    public function setSlugLevel($slugLevel)
    {
        $this->slugLevel = $slugLevel;
        return $this;
    }
}
