<?php


namespace Cms\Client\Command\Article\Command;

use Cms\Client\Command\ScopeFilterAwareInterface;
use Cms\Client\Command\ScopeFilterAwareTrait;
use Move\Command\Command\FetchCommand;

/**
 * Class FetchArticleCommand
 * @package AutoMag\Command\Article\Command
 */
class FetchArticleCommand extends FetchCommand implements ScopeFilterAwareInterface
{

    use ScopeFilterAwareTrait;

    /** @var  string */
    protected $slug;

    /** @var  string|null */
    protected $language;

    /**
     * FetchArticleCommand constructor.
     * @param mixed $id
     * @param null|string $slug
     */
    public function __construct($id = null, $slug = null)
    {
        parent::__construct($id);
        $this->slug = $slug;
    }

    /**
     * @param string $slug
     * @return $this
     */
    public function setSlug($slug)
    {
        $this->slug = $slug;
        return $this;
    }

    /**
     * @return string
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * @return int
     */
    public function getArticleId()
    {
        return $this->getId();
    }

    /**
     * @param null|string $language
     * @return $this
     */
    public function setLanguage($language)
    {
        $this->language = $language;
        return $this;
    }

    /**
     * @return null|string
     */
    public function getLanguage()
    {
        return $this->language;
    }
}
