<?php

namespace Cms\Client\Command\Campsite\Product;

use Cms\Cache\CacheHelperTrait;
use Cms\Client\Command\Campsite\Command\FetchBulkProductCommand;
use Cms\Client\Command\CommandExceptionHandleTrait;
use Cms\Client\Service\CampsiteService;
use Move\Cache\CacheAwareInterface;
use Move\Http\Client\Exception\HttpRequestException;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;

/**
 * Class ProductCommandHandler
 * @package Cms\Client\Command\Campsite\Product
 */
class ProductCommandHandler implements
    CacheAwareInterface,
    LoggerAwareInterface
{

    use CacheHelperTrait;
    use LoggerAwareTrait;
    use CommandExceptionHandleTrait;

    /**
     * @var CampsiteService
     */
    protected $service;

    /**
     * ProductCommandHandler constructor.
     * @param CampsiteService $service
     */
    public function __construct(CampsiteService $service)
    {
        $this->service = $service;
    }

    /**
     * @param FetchBulkProductCommand $command
     * @return array|\Cms\Client\Campsite\Model\ProductRestfulModel[]
     * @throws \RuntimeException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     * @throws \Move\Command\Exception\NotFoundException
     */
    public function handleFetchBulkProduct(FetchBulkProductCommand $command) : array
    {
        $productClient = $this->service->getProductClient();
        try {
            $products = $productClient->fetchBulkItems($command->getIds());
        } catch (HttpRequestException $e) {
            $this->logHttpRequestException('ProductCmdHd_FetchBulkProduct', $e);
        }
        return $products ?? [];
    }
}
