<?php

namespace Cms\Extension\Component;

use Cms\Client\Geodata\Helper\GeodataHelperTrait;
use Cms\Client\Service\GeodataService;
use Cms\Client\Service\GeodataServiceAwareTrait;
use League\Plates\Template\Template;
use Move\Template\Component\AbstractComponent;

/**
 * Class GeoCityComponent
 * @package Cms\Extension\Component
 */
class GeoCityComponent extends AbstractComponent
{

    use GeodataServiceAwareTrait;
    use GeodataHelperTrait;

    /** @var string */
    protected $functionName = 'geocities';

    /**
     * GeoCityComponent constructor.
     * @param \Cms\Client\Service\GeodataService $geodataService
     */
    public function __construct(GeodataService $geodataService)
    {
        $this->setGeodataService($geodataService);
    }

    /**
     * @param Template $template
     * @param array $data
     * @throws \DomainException
     */
    protected function assignData(Template $template, $data = [])
    {
        if (!empty($data['city_ids']) && \is_array($data['city_ids'])) {
            try {
                $results = $this->getGeodataService()->getCityClient()
                    ->fetchBulkItems($data['city_ids']);
                $cityNames = [];
                foreach ($results as $city) {
                    $cityNames[] = $city['name_ascii'];
                }
                $sort = $data['sort'] ?? true;
                if ($sort) {
                    array_multisort($cityNames, SORT_ASC, SORT_STRING, $results);
                }
                $data['geocities'] = $results;
            } catch (\Exception $e) {
                trigger_error((string)$e);
            }
        } else {
            $admin1Code = $data['admin1_code'] ?? null;
            $admin2Code = $data['admin2_code'] ?? null;
            if ($admin1Code xor $admin2Code) {
                try {
                    $results = $this->getGeodataService()->getCityClient()->getBuilder()
                        ->setFilter('admin1_code', $admin1Code)
                        ->setFilter('admin2_code', $admin2Code)
                        ->setSortCol('name_ascii', 'asc')
                        ->getIndex(-1);
                    $data['geocities'] = iterator_to_array($results, false);
                } catch (\Exception $e) {
                    trigger_error((string)$e);
                }
            }
        }

        $template->data($data);
    }
}
