<?php


namespace Cms\Extension\MediaHandler;

use Cms\Client\AssetConfigRelationRestfulModel;
use Cms\Model\Asset\AssetProfil;
use Cms\Model\Asset\Config\ConfigEmbedVideoModel;
use League\Plates\Template\Template;
use Move\ObjectMapper\ObjectTransformer;

/**
 * Class MediaHandlerVideoEmbed
 * @package Cms\Extension\MediaHandler
 */
class MediaHandlerVideoEmbed extends AbstractMediaHandlerComponent
{

    use MediaHandlerSizeTrait;

    /** @var array */
    protected $provides = [
        AssetProfil::EMBED_VIDEO,
    ];

    /**
     * @param Template $template
     * @param AssetConfigRelationRestfulModel $assetModel
     * @param array $handlerConfig
     */
    protected function assignData(
        Template $template,
        AssetConfigRelationRestfulModel $assetModel,
        array $handlerConfig = []
    ) {
        parent::assignData($template, $assetModel, $handlerConfig);

        // récuperation du format
        $format = null;
        if (!empty($handlerConfig['format'])) {
            $format = $handlerConfig['format'];
        }
        if (($formatData = $this->getFormatSize($format)) !== null) {
            $template->data($formatData);
        }

        // chargement de la config
        if (!empty($assetModel->asset_config)
            && $assetModel->asset_config->config instanceof ConfigEmbedVideoModel
        ) {
            $configData = (new ObjectTransformer())->transform($assetModel->asset_config->config);
            $iframeCode = $configData['iframe_code'] ?? '';
            if (!empty($iframeCode)
                && empty($configData['iframe_src'])
                && preg_match('@<iframe.+src="([^"]+)"@i', $iframeCode, $matches)
            ) {
                $configData['iframe_src'] = $matches[1];
            }
            $template->data($configData);
        }
    }
}
