<?php


namespace Cms\Extension\TemplateBloc;

use Cms\Cache\CacheHelperTrait;
use Psr\Cache\CacheItemInterface;

/**
 * Class BlocHandlerCacheTrait
 * @package Cms\Extension\TemplateBloc
 */
trait BlocHandlerCacheTrait
{

    use CacheHelperTrait;

    /**
     * @param mixed $blocModel
     * @param string $name
     * @param int|null $ttl
     * @param null $cacheItem
     * @return bool|null
     */
    protected function getFromCache(
        $blocModel,
        $name,
        $ttl = null,
        &$cacheItem = null
    ) {
        $blocModelSign = md5(serialize($blocModel));
        $cacheKey = $blocModel->scope_id . '^' . $blocModel->type . '^' . $blocModel->id . '^' . $blocModelSign;
        $hit = $this->hitFromCache($name . '^' . $cacheKey, $ttl ?: 120, $cacheItem);
        if ($cacheItem instanceof CacheItemInterface) {
            return $hit;
        }
        return null;
    }
}
