<?php


namespace Cms\Model\AddressBook\Address;

use Cms\Model\ScopeAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class AddressCategoryModel
 * @package Cms\Model\AddressBook\Address
 * @property int $id
 * @property int $parent_id
 * @property string $name
 * @property string $description
 * @property int $rank
 * @property AddressCategoryState $state
 * @property string $attr_group
 */
class AddressCategoryModel extends DomainObjectAbstract
{

    use ScopeAwareModelTrait;

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $parent_id;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $description;

    /** @var  int */
    protected $rank;

    /** @var  AddressCategoryState */
    protected $state;

    /** @var  string */
    protected $attr_group;
}
