<?php


namespace Cms\Model\AddressBook;

use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\ScopeAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class AddressBookModel
 * @package Cms\Model\AddressBook
 * @property int $id
 * @property string $name
 * @property string $slug
 * @property string $description
 * @property AddressBookState $state
 * @property int $oracle_id
 * @property string $oracle_type
 */
class AddressBookModel extends DomainObjectAbstract
{

    use StampAwareModelTrait;
    use ScopeAwareModelTrait;
    use CmsUserIdAwareTrait;

    /** @var  int */
    protected $id;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $slug;

    /** @var  string */
    protected $description;

    /** @var  AddressBookState */
    protected $state;

    /** @var  int */
    protected $oracle_id;

    /** @var  string */
    protected $oracle_type;
}
