<?php


namespace Cms\Model\AddressBook\Trip;

use Cms\Model\ScopeAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class TripCategoryModel
 * @package Cms\Model\AddressBook\Trip
 * @property int $id
 * @property int $parent_id
 * @property string $name
 * @property string $description
 * @property int $rank
 * @property TripCategoryState $state
 */
class TripCategoryModel extends DomainObjectAbstract
{

    use ScopeAwareModelTrait;

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $parent_id;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $description;

    /** @var  int */
    protected $rank;

    /** @var  TripCategoryState */
    protected $state;
}
