<?php

namespace Cms\Model\Article\Plugin;

use Cms\Model\ConfigAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class PluginModel
 * @package Cms\Model\Article\Plugin
 * @property int $id
 * @property int $article_id
 * @property PluginType $type
 */
class PluginModel extends DomainObjectAbstract
{

    use StampAwareModelTrait;
    use ConfigAwareModelTrait;

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $article_id;

    /** @var  PluginType */
    protected $type;

    /**
     * @param string $offset
     * @param mixed $value
     */
    public function propertySet($offset, $value)
    {
        if ($offset === 'config') {
            $this->setConfig($value);
        } else {
            parent::propertySet($offset, $value);
        }
    }
}
