<?php

namespace Cms\Model\Contract;

use Cms\LinkResource\LinkResourceModel;
use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\ScopeAwareModelTrait;
use Cms\Model\StampAwareModelTrait;

/**
 * Class ContractModel
 * @package Cms\Model\Contract
 * @property string $description
 * @property string $reference
 * @property ContractState $state
 * @property \DateTime $begin_at
 * @property \DateTime $end_at
 */
class ContractModel extends LinkResourceModel
{

    use StampAwareModelTrait;
    use ScopeAwareModelTrait;
    use CmsUserIdAwareTrait;

    /** @var  string */
    protected $description;

    /** @var  ContractState */
    protected $state;

    /** @var  \DateTime */
    protected $begin_at;

    /** @var  \DateTime */
    protected $end_at;

    /** @var  string */
    protected $reference;
}
