<?php

namespace Cms\Model\Scheduler\Task;

use Cms\Specification\PeriodicitySpecification;
use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EnumSpecification;

/**
 * Class TaskValidator
 * @package Cms\Model\Scheduler\Task
 */
class TaskValidator extends AbstractDomainObjectStateValidator
{

    /**
     * @return Filter
     */
    protected function createFilter()
    {
        $filter = new Filter([
            'name' => true,
            /*'execution_at' => function ($execDate) {
                if (is_numeric($execDate)) {
                    $execDate = new \DateTime('@' . $execDate);
                } elseif (is_string($execDate) && false === ($execDate = strtotime($execDate))) {
                    return false;
                }
                // check si date et si dans le future
                return $execDate instanceof \DateTime && $execDate > new \DateTime();
            },*/
            'state' => new EnumSpecification(TaskState::class),
            'action_type' => new EnumSpecification(TaskActionType::class),
            'periodicity' => (new EnumSpecification(TaskPeriodicity::class))
                ->orSpec(new PeriodicitySpecification()),
        ]);
        return $filter;
    }
}
