<?php


namespace Cms\Search\Campsite;

use Cms\Search\AbstractSearchClient;

/**
 * Class CampsiteSearchClient
 * @package Cms\Search\Campsite
 */
class CampsiteSearchClient extends AbstractSearchClient
{

    /**
     * @var array
     */
    protected $sortCols = [
        '_score',
        'id',
        'modified_at',
        'created_at',
        'classmnt_nbstars',
        'addresses.city_name.raw',
        'addresses.postal_code',
        'slug',
    ];

    /**
     * @return array
     */
    protected function getDefaultMatchFields() : array
    {
        return ['campsite_name^5',];
    }

    /**
     * @return string
     */
    protected function getMappingType() : string
    {
        return CampsiteIndexFactory::MAPPING_NAME;
    }
}
