<?php

namespace Cms\Worker\Command\Scheduler;

/**
 * Class SchedulerCommand
 * @package Cms\Worker\Command\Scheduler
 */
class SchedulerCommand
{

    /** @var int */
    private $limitRunning;

    /** @var array|int|null */
    private $scopeId;

    /**
     * SchedulerCommand constructor.
     * @param int|array $scopeId
     * @param int $limitRunning
     */
    public function __construct($scopeId = null, int $limitRunning = 0)
    {
        $this->scopeId = $scopeId;
        $this->limitRunning = max($limitRunning, 0);
    }

    /**
     * @return array|int|null
     */
    public function getScopeId()
    {
        return $this->scopeId;
    }

    /**
     * @return int
     */
    public function getLimitRunningJob() : int
    {
        return $this->limitRunning;
    }
}
