<?php

namespace Move;

/**
 * Class BitwiseFlagAbstract
 * @package Move
 */
trait BitwiseFlagTrait
{

    protected $flags;

    /**
     * @param int $flag
     * @return bool
     */
    protected function isFlagSet($flag)
    {
        return (($this->flags & $flag) == $flag);
    }

    /**
     * @param int $flag
     * @param bool $value
     */
    protected function setFlag($flag, $value)
    {
        if ($value) {
            $this->flags |= $flag;
        } else {
            $this->flags &= ~$flag;
        }
    }
}
