<?php


namespace Move\Command\Exception;

use Exception;

/**
 * Class RelationException
 * @package Move\Command\Exception
 */
class RelationException extends \OutOfBoundsException implements CommandException
{

    /**
     * @var null
     */
    private $foreignKey;

    /**
     * RelationException constructor.
     * @param string $message
     * @param int $code
     * @param Exception $previous
     * @param null $foreignKey
     */
    public function __construct($message, $code, Exception $previous, $foreignKey = null)
    {
        parent::__construct($message, $code, $previous);
        $this->foreignKey = $foreignKey;
        if ($previous instanceof \PDOException && !empty($previous->errorInfo[2])) {
            if (1 === preg_match('@FOREIGN KEY\s*\(`([^`]+)`\)@i', $previous->errorInfo[2], $matches)) {
                $this->foreignKey = $matches[1];
            }
        }
    }

    /**
     * @return null|string
     */
    public function getForeignKey()
    {
        return $this->foreignKey;
    }
}
