<?php

namespace Move\Embed\Adapter;

use Move\Embed\EmbedModel;
use Move\Embed\Normalizer\NormalizerInterface;

/**
 * Class GoogleMaps
 * @package Move\Embed\Adapter
 */
class GoogleMaps implements AdapterInterface
{

    /** @var \Move\Embed\Normalizer\NormalizerInterface */
    private $normalizer;

    /** @var \Move\Embed\Normalizer\NormalizerInterface */
    private $thumbNormalizer;

    /**
     * @param \Move\Embed\Normalizer\NormalizerInterface $iframeNormalizer
     * @param \Move\Embed\Normalizer\NormalizerInterface $thumbnailNormalizer
     */
    public function __construct(NormalizerInterface $iframeNormalizer, NormalizerInterface $thumbnailNormalizer)
    {
        $this->normalizer = $iframeNormalizer;
        $this->thumbNormalizer = $thumbnailNormalizer;
    }

    /**
     * Renvoi les données de la source sous forme de model
     * @param string $sourceUri
     * @param array $params
     * @return EmbedModel|null
     * @throws \ReflectionException
     */
    public function getEmbedModel($sourceUri, array $params = [])
    {
        $requestUri = $this->normalizer->normalizeStr($sourceUri);
        $imageUrl = $this->thumbNormalizer->normalizeStr($sourceUri);
        $iframe = '<iframe src="' . $requestUri . '" frameborder="0" style="border:0"></iframe>';
        return new EmbedModel([
            'title' => '',
            'provider_name' => 'Google Maps',
            'provider_url' => 'https://maps.google.com',
            'author_name' => 'Google',
            'html' => $iframe,
            'thumbnail_url' => $imageUrl ?: null,
            'canonical_url' => $requestUri,
            'source_url' => $sourceUri,
        ]);
    }
}
