<?php


namespace Move\Filter\Validator;

use Move\Filter\Filter;
use POM\DomainObjectInterface;

/**
 * Class DomainObjectStateValidator
 * @package Move\Filter\Validator
 */
class DomainObjectStateValidator implements StateValidatorInterface
{
    
    /**
     * @var Filter
     */
    private $filter;

    /**
     * DomainObjectValidator constructor.
     * @param Filter|null $filter
     */
    public function __construct(Filter $filter = null)
    {
        $this->filter = $filter ?: new Filter();
    }

    /**
     * @param DomainObjectInterface $object
     * @throws \InvalidArgumentException
     * @return bool
     */
    public function validateState(&$object)
    {
        if (!$object instanceof DomainObjectInterface) {
            throw new \InvalidArgumentException();
        }

        // filtrage
        $dataObject = $this->filter->process($object->getArrayCopy());

        // check des failed et envoi Exception
        if (($specs = $this->filter->getFailedSpecs())) {
            throw new StateValidatorException(key($specs));
        }

        // mise a jour de l'objet
        $object->populate($dataObject);
        return true;
    }
}
