<?php


namespace Move\Http\Route;

use League\Container\ContainerAwareInterface;
use League\Container\ContainerAwareTrait;

/**
 * Class AbstractRouteProvider
 * @package Move\Http\Route
 */
abstract class AbstractRouteProvider implements ContainerAwareInterface
{

    use ContainerAwareTrait;

    /**
     * @var RouterAdapterInterface
     */
    protected $router;

    /**
     * @param RouterAdapterInterface $router
     * @return AbstractRouteProvider
     */
    final public function setRouterAdapter(RouterAdapterInterface $router)
    {
        $this->router = $router;
        return $this;
    }

    /**
     * @return void
     */
    abstract public function register();
}
