<?php

namespace Move\Specification;

/**
 * Class NotSpecification
 * @package Move\Specification
 */
class NotSpecification extends Specification
{

    /**
     * @var SpecificationInterface
     */
    private $specification;

    /**
     * @param SpecificationInterface $specification
     */
    public function __construct(SpecificationInterface $specification)
    {
        $this->specification = $specification;
    }

    /**
     * @inheritdoc
     */
    public function isSatisfiedBy($object) : bool
    {
        return !$this->specification->isSatisfiedBy($object);
    }
}
