<?php


namespace Move\Template;

use League\Plates\Engine;
use Move\Template\Extensions\AssetHtml;
use Move\Template\Html\Asset\AssetCollection;
use Move\Template\Html\Asset\AssetInterface;

/**
 * Class AssetEngineTrait
 * @package Move\Template
 */
trait AssetEngineTrait
{

    /**
     * @return Engine
     */
    abstract function getEngine();

    /**
     * @param AssetCollection|AssetInterface[]|AssetInterface $assets
     * @param array $tags
     * @return $this
     */
    protected function addAssets($assets, array $tags = [])
    {
        if (!$assets instanceof AssetCollection) {
            if ($assets instanceof AssetInterface) {
                $assets = [$assets];
            }
            if (!\is_array($assets)) {
                throw new \InvalidArgumentException('must be an array of AssetInterface');
            }
            $assets = (new AssetCollection())->addMulti($assets, $tags);
        }
        $this->getEngine()->loadExtension(new AssetHtml($assets));
        return $this;
    }
}
