<?php

namespace Move\Template\Extensions;

use League\Plates\Engine;
use League\Plates\Extension\ExtensionInterface;

/**
 * Class Compare
 * @package Move\Template\Extensions
 */
class Compare implements ExtensionInterface
{

    /**
     * @inheritdoc
     */
    public function register(Engine $engine)
    {
        $engine->registerFunction('ifshow', [$this, 'runIfshow']);
    }

    /**
     * @param mixed $var
     * @param mixed $withVar
     * @param string $successed
     * @param string $failed
     * @return string
     */
    public function runIfshow($var, $withVar, $successed = null, $failed = null)
    {
        return $var === $withVar ? $successed : $failed;
    }
}
