<?php

namespace Move\Template\Html\Asset;

/**
 * Class Css
 * @package Move\Template\Html\Asset
 */
class Css implements AssetInterface
{

    /**
     * @var bool
     */
    private static $ASYNC_LOAD = false;

    /**
     * @var
     */
    private static $VERSION;

    /**
     * @var bool
     */
    protected $import = false;

    /**
     * @var bool
     */
    protected $async;

    /**
     * @var string
     */
    protected $src;

    /**
     * @var null|string
     */
    protected $condition;

    /**
     * @var null|string
     */
    protected $media;

    /**
     * la condition doit être de la forme 'lte IE 8'... (voir http://msdn.microsoft.com/en-us/library/ms537512.ASPX)
     * @param string $src
     * @param string $condition
     * @param string $media
     * @param bool $async
     */
    public function __construct($src, $condition = null, $media = null, $async = false)
    {
        $this->src = $src;
        $this->condition = $condition;
        $this->media = $media ?: 'all';
        $this->async = $async;
    }

    /**
     * @param boolean $valide
     */
    public function renderInImport($valide = true)
    {
        $this->import = $valide;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return $this->render();
    }

    /**
     * {@inheritdoc}
     * @return string
     */
    public function render()
    {
        $src = $this->src;
        if (!empty(self::$VERSION)) {
            $src .= (strpos($this->src, '?') ? '&' : '?') . 'v=' . self::$VERSION;
        }
        $media = $this->media ? ' media="' . $this->media . '"' : '';
        if ($this->import === true) {
            $source = '<style type="text/css"' . $media . '> @import url(' . $src . '); </style>';
        } else {
            if ($this->async === true) {
                $source = <<<EOF
<script>MoveLoadCSS("$src", null, "$this->media");</script>
<noscript><link href="$src" rel="stylesheet" type="text/css" $media></noscript>
EOF;
            } else {
                $source = '<link rel="stylesheet" type="text/css" href="' . $src . '"' . $media . '>';
            }
        }
        if ($this->condition) {
            $source = '<!--[if ' . $this->condition . ']>' . $source . '<![endif]-->';
        }

        if ($this->async === true && !self::$ASYNC_LOAD) {
            self::$ASYNC_LOAD = true;
            $source = <<<EOF
<script>function MoveLoadCSS(e,n,o,t){"use strict";var d=window.document.createElement("link"),i=n||window.document.getElementsByTagName("script")[0],s=window.document.styleSheets;return d.rel="stylesheet",d.href=e,d.media="only x",t&&(d.onload=t),i.parentNode.insertBefore(d,i),d.onloadcssdefined=function(n){for(var o,t=0;t<s.length;t++)s[t].href&&s[t].href.indexOf(e)>-1&&(o=!0);o?n():setTimeout(function(){d.onloadcssdefined(n)})},d.onloadcssdefined(function(){d.media=o||"all"}),d}</script>
$source
EOF;
        }
        return $source;
    }

    /**
     * Renvoi la copie sous forme de tableau de la metadata
     * @return array
     */
    public function getArrayCopy()
    {
        return [
            'src' => $this->src,
            'media' => $this->media,
            'condition' => $this->condition
        ];
    }

    /**
     * @param string $version
     */
    public static function setVersionNumber($version)
    {
        self::$VERSION = $version;
    }
}
