<?php

namespace Move\Embed\Parser;

use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class RegexParserTest
 * @package Move\Embed\Parser
 */
class RegexParserTest extends TestCase
{
    /**
     * @return array
     */
    public static function provideMatchString()
    {
        $regex = '/[a-z]+/';
        return [
            [$regex, '123456789', []],
            [$regex, 'abc6789', ['abc']],
            [$regex, 'abc123456cba', ['abc','cba']]
        ];
    }

    /**
     * @covers RegexParser::__construct
     * @return RegexParser
     */
    public function testConstruct()
    {
        $regexString = '/[a-z]+/';
        $instance = new RegexParser($regexString);
        $this->assertInstanceOf(RegexParser::class, $instance);

        $this->assertEquals(
            $regexString,
            Reflection::getValue($instance, 'regex')
        );
    }

    /**
     * @dataProvider provideMatchString
     * @param $regex
     * @param $string
     * @param $expected
     */
    public function testMatchString($regex, $string, $expected)
    {
        $instance = new RegexParser($regex);
        $res = $instance->matchString($string, $found);

        if (empty($expected)) {
            $this->assertFalse($res);
        } else {
            $this->assertTrue($res);
        }

        $this->assertEquals($expected, $found);
    }

    /**
     * @dataProvider provideMatchString
     * @depends testConstruct
     * @covers RegexParser::_invoke
     * @param $regex
     * @param $string
     * @param $expected
     */
    public function testInvoke($regex, $string, $expected)
    {
        $instance = new RegexParser($regex);
        $found = [];
        $res = $instance($string, $found);

        if (empty($expected)) {
            $this->assertFalse($res);
        } else {
            $this->assertTrue($res);
        }

        $this->assertEquals($expected, $found);
    }
}
