<?php

namespace Cms\Client\Campsite\Transformer;

use Cms\Bundle\Helper\CampsiteHelper;
use Cms\Client\AddressBook\Model\AddressRestfulModel;
use Cms\Client\Campsite\Model\CampsiteRestfulModel;
use Cms\LinkResource\LinkResourceHandlerAwareInterface;
use Cms\LinkResource\LinkResourceHandlerAwareTrait;
use Cms\LinkResource\LinkResourcePrefsIdentifier;
use Move\ObjectMapper\ObjectTransformer;
use POM\DomainObjectInterface;

/**
 * Class CampsiteTransformer
 * @package Cms\Client\Campsite\Transformer
 */
class CampsiteTransformer extends ObjectTransformer implements
    LinkResourceHandlerAwareInterface
{

    use LinkResourceHandlerAwareTrait;

    /**
     * @param \POM\DomainObjectInterface $object
     * @return array
     * @throws \UnexpectedValueException
     */
    public function transform(DomainObjectInterface $object)
    {
        $dataset = parent::transform($object);
        if (!$object instanceof CampsiteRestfulModel) {
            return $dataset;
        }

        // address
        $dataset['address_loc'] = $this->getFirstObjectAddress(
            $object,
            LinkResourcePrefsIdentifier::ADDRESS_LOC
        );
        if ($dataset['address_loc'] instanceof AddressRestfulModel) {
            $adminCodeConcat = $dataset['address_loc']->getAdmin2CodeConcat();
            $dataset['address_loc'] = (new ObjectTransformer())->transform($dataset['address_loc']);
            $dataset['address_loc']['admin2_code_concat'] = $adminCodeConcat;
        }

        $dataset['address_adm'] = $this->getFirstObjectAddress(
            $object,
            LinkResourcePrefsIdentifier::ADDRESS_ADMIN
        );
        if ($dataset['address_adm'] instanceof AddressRestfulModel) {
            $adminCodeConcat = $dataset['address_adm']->getAdmin2CodeConcat();
            $dataset['address_adm'] = (new ObjectTransformer())->transform($dataset['address_adm']);
            $dataset['address_adm']['admin2_code_concat'] = $adminCodeConcat;
        }

        // listing des group
        $dataset['campsite_groups'] = array_map(function ($groups) {
            return $groups['group_id'];
        }, $dataset['groups']);

        // facilité pour la lecture des donnée d'adresse
        $cityName = $dataset['address_loc']['city_name'];
        $countryCode = $dataset['address_loc']['country_alpha2'];
        $cityCp = $dataset['address_loc']['postal_code'];
        $deptCode = $dataset['address_loc']['admin2_code'];
        $cityRoad = $dataset['address_loc']['address1'];
        $gpsLoc = null;
        if (!empty($dataset['address_loc']['gps_location'])) {
            $gpsLoc = $dataset['address_loc']['gps_location'];
        }

        // récuperation du classement du campings
        list($nbetoile, $isPRL, $isFFCC) = CampsiteHelper::getCampsiteClassement($object->features);
        $dataset = array_merge($dataset, [
            'features_idx' => $object->getFeatureIndex(),
            'gps_location' => $gpsLoc,
            'admin_code' => $deptCode,
            'city_name' => $cityName,
            'city_cp' => $cityCp,
            'city_road' => $cityRoad,
            'country_code' => $countryCode,
            'is_ffcc' => $isFFCC,
            'classmnt' => $nbetoile,
            'classmnt_prl' => $isPRL,
        ]);

        return $dataset;
    }
}
