<?php

namespace Cms\Client\Campsite\Transformer;

use Cms\Client\Campsite\Model\GroupRestfulModel;
use Cms\Model\Campsite\Group\GroupLogoModel;
use Move\ObjectMapper\ObjectTransformer;
use POM\DomainObjectInterface;

/**
 * Class GroupTransformer
 * @package Cms\Client\Campsite\Transformer
 */
class GroupTransformer extends ObjectTransformer
{

    /**
     * @param \POM\DomainObjectInterface|\Cms\Client\Campsite\Model\GroupRestfulModel $object
     * @return array
     */
    public function transform(DomainObjectInterface $object) : array
    {
        $dataset = parent::transform($object);
        if (!$object instanceof GroupRestfulModel) {
            return $dataset;
        }

        // formatage des logos par langue
        $dataset['logos'] = array_combine(array_map(function (GroupLogoModel $logo) {
            return $logo->language;
        }, $object->logos), $dataset['logos']);

        return $dataset;
    }
}
