<?php


namespace Cms\Client\Service;

use Cms\Client\Asset\AssetClient;
use Cms\Client\Asset\AssetConfigClient;
use Cms\Client\Asset\AssetTagClient;

/**
 * Class AssetService
 * @package Cms\Client\Service
 */
class AssetService
{
    /**
     * @var AssetClient
     */
    private $assetClient;
    /**
     * @var AssetTagClient
     */
    private $assetTagClient;

    /** @var AssetConfigClient */
    private $assetConfigClient;

    /**
     * AssetService constructor.
     * @param AssetClient $assetClient
     * @param AssetTagClient $assetTagClient
     * @param AssetConfigClient $assetConfigClient
     */
    public function __construct(
        AssetClient $assetClient,
        AssetTagClient $assetTagClient,
        AssetConfigClient $assetConfigClient
    ) {
        $this->assetClient = $assetClient;
        $this->assetTagClient = $assetTagClient;
        $this->assetConfigClient = $assetConfigClient;
    }

    /**
     * @return AssetClient
     */
    public function getAssetClient()
    {
        return $this->assetClient;
    }

    /**
     * @return AssetTagClient
     */
    public function getAssetTagClient()
    {
        return $this->assetTagClient;
    }

    /**
     * @return AssetConfigClient
     */
    public function getAssetConfigClient()
    {
        return $this->assetConfigClient;
    }
}
