<?php


namespace Cms\LinkResource\Provider\CMS;

use Cms\LinkResource\LinkResourceType;
use Cms\LinkResource\Provider\AbstractDelegateDataAdapter;
use Cms\Model\Campsite\CampsiteModel;
use Cms\Model\Campsite\Group\GroupModel;
use Cms\Model\Campsite\Thematic\ThematicModel;
use POM\DomainObjectInterface;
use Psr\Cache\CacheItemPoolInterface;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;

/**
 * Class AbstractCmsCampsiteProvider
 * @package Cms\LinkResource\Provider\CMS
 */
abstract class AbstractCmsCampsiteProvider extends AbstractDelegateDataAdapter implements
    CmsProviderScopeAwareInterface
{

    use CmsProviderScopeAwareTrait;

    /** @var array */
    protected $types = [
        LinkResourceType::CAMPSITE,
        LinkResourceType::CAMPSITE_THEMATIC,
        LinkResourceType::CAMPSITE_GROUP,
    ];

    /**
     * AbstractCmsCampsiteProvider constructor.
     * @param \Psr\Cache\CacheItemPoolInterface|null $cachePool
     * @param \Psr\Log\LoggerInterface|null $logger
     */
    public function __construct(
        CacheItemPoolInterface $cachePool = null,
        LoggerInterface $logger = null
    ) {
        if ($cachePool !== null) {
            $this->setItemCachePool($cachePool);
        }
        $this->setLogger($logger ?: new NullLogger());
    }

    /**
     * @inheritdoc
     */
    public function getLabelFromModel(DomainObjectInterface $model)
    {
        if ($model instanceof CampsiteModel) {
            return $model->name;
        }
        if ($model instanceof GroupModel
            || $model instanceof ThematicModel
        ) {
            return $model->name . ' (' . $model->type . ')';
        }
        return null;
    }
}
