<?php


namespace Cms;

/**
 * Class MergeByKeyIterator
 * @package Cms
 */
class MergeByKeyIterator implements \SeekableIterator
{

    const ONE_PUSH_TWO = 0x2;

    const TWO_PUSH_ONE = 0x4;

    const ONE_REPLACE_TWO = 0x6;

    const TWO_REPLACE_ONE = 0x8;

    /** @var \Iterator */
    private $iterator;

    /** @var \Iterator */
    private $iterator2;

    /** @var  int */
    private $current_position = 0;

    /** @var int|null */
    private $flags;

    /** @var  \Iterator */
    private $current_iterator;

    /**
     * MergeByKeyIterator constructor.
     * @param \Iterator $iterator
     * @param \Iterator $iterator2
     * @param null|int $flags
     */
    public function __construct(\Iterator $iterator, \Iterator $iterator2, $flags = null)
    {
        $this->iterator = $iterator;
        $this->iterator2 = $iterator2;
        $this->flags = $flags ?: self::TWO_PUSH_ONE;
    }

    /**
     * Return the current element
     * @link http://php.net/manual/en/iterator.current.php
     * @return mixed Can return any type.
     * @since 5.0.0
     */
    public function current()
    {
        //var_dump(get_class($this->current_iterator) . ":" . $this->current_iterator->key());
        return $this->current_iterator->current();
    }

    /**
     * Move forward to next element
     * @link http://php.net/manual/en/iterator.next.php
     * @return void Any returned value is ignored.
     * @since 5.0.0
     */
    public function next()
    {
        //var_dump('next it : ' . get_class($this->current_iterator));
        $this->current_iterator->next();
        $this->current_position++;
        // calcul du current iterator
        $this->setCurrentIterator();
    }

    /**
     * Return the key of the current element
     * @link http://php.net/manual/en/iterator.key.php
     * @return mixed scalar on success, or null on failure.
     * @since 5.0.0
     */
    public function key()
    {
        //var_dump('get it key : ' . $this->current_position);
        return $this->current_position;
    }

    /**
     * Checks if current position is valid
     * @link http://php.net/manual/en/iterator.valid.php
     * @return boolean The return value will be casted to boolean and then evaluated.
     * Returns true on success or false on failure.
     * @since 5.0.0
     */
    public function valid()
    {
        //var_dump('is valid it : ' . get_class($this->current_iterator));
        return $this->current_iterator->valid();
    }

    /**
     * Rewind the Iterator to the first element
     * @link http://php.net/manual/en/iterator.rewind.php
     * @return void Any returned value is ignored.
     * @since 5.0.0
     */
    public function rewind()
    {
        //var_dump('rewind its');
        $this->current_position = 0;
        $this->iterator->rewind();
        $this->iterator2->rewind();
        $this->setCurrentIterator();
    }

    /**
     * Seeks to a position
     * @link http://php.net/manual/en/seekableiterator.seek.php
     * @param int $position <p>
     * The position to seek to.
     * </p>
     * @return void
     * @since 5.1.0
     */
    public function seek($position)
    {
        if ($this->iterator instanceof \SeekableIterator) {
            $this->iterator->seek($position);
        }
        if ($this->iterator2 instanceof \SeekableIterator) {
            $this->iterator2->seek($position);
        }
        $this->setCurrentIterator();
    }

    /**
     * @return void
     */
    protected function setCurrentIterator()
    {
        if (!$this->iterator->valid()) {
            $this->current_iterator = $this->iterator2;
        } elseif (!$this->iterator2->valid()) {
            $this->current_iterator = $this->iterator;
        } else {
            $rank1 = $this->iterator->key();
            $rank2 = $this->iterator2->key();
            if ($this->current_position >= $rank2) {
                $this->current_iterator = $this->iterator2;
            } elseif ($this->current_position >= $rank1) {
                $this->current_iterator = $this->iterator;
            }
        }
    }
}
