<?php


namespace Cms\Model\AddressBook\Trip;

use Cms\Model\Geodata\GeodataAwareModelInterface;
use Cms\Model\Geodata\GeodataAwareModelTrait;
use Cms\Model\GpsLocationPointModelTrait;
use POM\DomainObjectAbstract;
use POM\PredefinedType\GpsLocationPoint;

/**
 * Class TripStepModel
 * @package Cms\Model\AddressBook\Trip
 * @property int $id
 * @property int $step_id
 * @property int $address_id
 * @property int $elevation
 * @property string $name
 * @property string $description
 * @property string $city_name
 * @property string $city_osm_id
 * @property TripStepType $type
 * @property TripLinkType $link_type
 * @property int $rank
 * @property \POM\PredefinedType\GpsLocationPoint $gps_location
 */
class TripStepModel extends DomainObjectAbstract implements GeodataAwareModelInterface
{

    use GeodataAwareModelTrait;
    use GpsLocationPointModelTrait {
        propertySet as gpsOffsetSet;
    }

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $trip_id;

    /** @var  int */
    protected $address_id;

    /** @var  string */
    protected $name;

    /** @var  int */
    protected $elevation;

    /** @var  string */
    protected $description;

    /** @var  string */
    protected $city_name;

    /** @var  string */
    protected $city_osm_id;

    /** @var  TripLinkType */
    protected $link_type;

    /** @var  TripStepType */
    protected $type;

    /** @var  int */
    protected $rank;

    /** @var  \POM\PredefinedType\GpsLocationPoint */
    protected $gps_location;

    /**
     * @inheritdoc
     */
    public function propertyGet($name)
    {
        $result = parent::propertyGet($name);
        if ($result instanceof GpsLocationPoint
            && (!$result->latitude || !$result->longitude)) {
            $result = null;
        }
        return $result;
    }

    /**
     * @param string $offset
     * @param mixed $value
     */
    public function propertySet($offset, $value)
    {
        if ($offset === 'gps_location') {
            if (is_scalar($value)) {
                $value = trim($value);
            }
            if (\is_array($value) && isset($value['latitude'], $value['longitude'])) {
                $value = (new GpsLocationPoint())->populate([
                    'latitude' => str_replace(',', '.', $value['latitude']),
                    'longitude' => str_replace(',', '.', $value['longitude']),
                ], true);
            }
            if ($value instanceof GpsLocationPoint) {
                parent::propertySet($offset, $value);
            } elseif (!empty($value)) {
                $this->gpsOffsetSet($offset, $value);
            } else {
                parent::propertySet($offset, null);
            }
        } else {
            parent::propertySet($offset, $value);
        }
    }
}
