<?php

namespace Cms\Model\Article\Category;

use Cms\Model\AbstractAssetConfigModel;
use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\ScopeAwareModelTrait;
use Cms\Model\StampAwareModelTrait;

/**
 * Class CategoryModel
 * @package Cms\Model\Article\Category
 * @property int $id
 * @property CategoryProfil $profil
 * @property string $name
 * @property string $abstract
 * @property string $slug
 * @property int $rank
 * @property string $anteriority
 * @property CategoryState $state
 */
class CategoryModel extends AbstractAssetConfigModel
{

    use StampAwareModelTrait;
    use ScopeAwareModelTrait;
    use CmsUserIdAwareTrait;

    /** @var  int */
    protected $id;

    /** @var  CategoryProfil */
    protected $profil;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $abstract;

    /** @var  string */
    protected $slug;

    /** @var  string */
    protected $anteriority;

    /** @var  CategoryState */
    protected $state;

    /** @var  int */
    protected $rank;
}
