<?php

namespace Cms\Model\Asset\Config;

use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\ConfigAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class ConfigModel
 * @package Cms\Model\Asset\Config
 * @property int $id
 * @property string $title
 * @property int $asset_id
 */
class ConfigModel extends DomainObjectAbstract
{

    use StampAwareModelTrait;
    use ConfigAwareModelTrait;
    use CmsUserIdAwareTrait;

    /** @var  int */
    protected $id;

    /** @var  string */
    protected $title;

    /** @var  int */
    protected $asset_id;

    /**
     * @param string $offset
     * @param mixed $value
     */
    public function propertySet($offset, $value)
    {
        if ($offset === 'config') {
            $this->setConfig($value);
        } else {
            parent::propertySet($offset, $value);
        }
    }
}
